#ifndef __CPresetBrowser__
#define __CPresetBrowser__

#include "CControlPanel.hpp"
#include "CMomentaryButton.hpp"
#include "CComboBox.hpp"
#include "CDiskPathMenuItem.hpp"
#include "IPresetHandler.hpp"
#include <Host/CFileManager.hpp>

//	===========================================================================

using Exponent::GUI::Controls::CControlPanel;
using Exponent::GUI::Controls::CMomentaryButton;
using Exponent::GUI::Controls::CComboBox;
using Exponent::GUI::Controls::CDiskPathMenuItem;
using Exponent::GUI::Controls::IPresetHandler;
using Exponent::Host::CFileManager;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @deprecated Not intended for public usage. This class is currently being redesigned and as such is marked as deprecated. It will be replaced in a future API verison
			 * @class CPresetBrowser CPresetBrowser.hpp
			 * @brief Allows the user to browse presets in a drag and droppable object
			 *
			 * @date 28/08/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CPresetBrowser.hpp,v 1.9 2007/02/08 21:07:54 paul Exp $
			 */
			class CPresetBrowser : public CControlPanel, public IActionListener
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================
		
			public:

//	===========================================================================

				/**
				 * @struct SPresetBrowserSetup CPresetBrowser.hpp
				 * @brief Setup information about the browser
				 */
				struct SPresetBrowserSetup
				{
					CDimension m_headArea;				/**< Size of the head area (contains load, save and bank select */
					CDimension m_selectorArea;			/**< Size of the selector which shows the files */

					CRect m_bankComboArea;				/**< Size of combo for the head */
					CRect m_loadButtonArea;				/**< Size of the load button for the head */
					CRect m_saveButtonArea;				/**< Size of the save button for the head */

					CFont *m_theFont;					/**< Font for the selector */
					CAlphaColour m_textColour;			/**< Colour of the text for the selector */

					IImage *m_bankComboUpImage;			/**< Combo box up image */
					IImage *m_bankComboDownImage;		/**< Combo box down image */
					IImage *m_saveButtonUpImage;		/**< Save button up image */
					IImage *m_saveButtonDownImage;		/**< Save button down image */
					IImage *m_loadButtonUpImage;		/**< Load button up image */
					IImage *m_loadButtonDownImage;		/**< Load button down image */

					CSystemString m_rootPath;			/**< Root path, nothing higher than this can be traversed by the selector */

					/**
					 * Initialise all the variables 
					 */
					void initialise()
					{
						NULL_POINTER(m_bankComboUpImage);
						NULL_POINTER(m_bankComboDownImage);
						NULL_POINTER(m_saveButtonUpImage);
						NULL_POINTER(m_saveButtonDownImage);
						NULL_POINTER(m_loadButtonUpImage);
						NULL_POINTER(m_loadButtonDownImage);
						NULL_POINTER(m_theFont);
					}
				};

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 * @param listener The action listener
				 */
				CPresetBrowser(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener = NULL);

				/**
				 * Destruction
				 */
				virtual ~CPresetBrowser();

//	===========================================================================

				/**
				 * Initialise
				 * @param setup The setup information for the browser
				 */
				void initialise(const SPresetBrowserSetup &setup);

				/**
				 * Set menu window attributes
				 * @param windowAttributes The attributes for the menu window
				 * @param colours The colours of the menu window
				 */
				void setMenuWindowAttributes(CWindowAttributes *windowAttributes, const SMenuColours &colours);

//	===========================================================================

				/**
				 * Handle an action event
				 * @param event The event to handle
				 * @note Intended for internal use, do not call
				 */
				virtual void handleActionEvent(const CActionEvent &event);

				/**
				 * Register the preset handler
				 * @param handler The handler for preset information
				 */
				virtual void registerPresetHandler(IPresetHandler *handler) { m_presetHandler = handler; }

//	===========================================================================

			protected:

//	===========================================================================

				/**
				 * @class CPresetBrowserSelector CPresetBrowser.hpp
				 * @brief Selector module, displays individual presets within a bank
				 */
				class CPresetBrowserSelector : public CControlPanel, public IActionListener
				{
					/** @cond */
					EXPONENT_CLASS_DECLARATION;
					/** @endcond */

//	===========================================================================
			
				public:

//	===========================================================================

					/**
					 * Construction
					 * @param root The root control
					 * @param uniqueId The unique id of this control
					 * @param area The area of the control
					 * @param font The font to draw with
					 * @param listener The action listener
					 * @param handler The preset handler to use
					 */
					CPresetBrowserSelector(IControlRoot *root, const long uniqueId, const CRect &area, CFont *font, IActionListener *listener = NULL, IPresetHandler *handler = NULL);

					/**
					 * Destruction
					 */
					virtual ~CPresetBrowserSelector();

//	===========================================================================

					/**
					 * Handle an action event
					 * @param event The event to handle
					 * @note Intended for internal use, do not call
					 */
					virtual void handleActionEvent(const CActionEvent &event);

//	===========================================================================

					/**
					 * Set he bank path
					 * @param bankPath The root bank path
					 */
					void setBankPath(const CSystemString &bankPath);

					/**
					 * Get the selected path
					 * @retval const CSystemString& The selected path
					 */
					const CSystemString &getSelectedPath() const { return m_filePath; }

					/**
					 * Set the font colour
					 * @param colour The colour to draw text with
					 */
					void setFontColour(const CAlphaColour &colour) { m_fontColour = colour; }

//	===========================================================================

				protected:

//	===========================================================================

					/**
					 * @class CPresetTextLabel CPresetBrowser.hpp
					 * @brief Specialised text label for the drawing of preset names on the window
					 */
					class CPresetTextLabel : public CTextLabel
					{
						/** @cond */
						EXPONENT_CLASS_DECLARATION;
						/** @endcond */

//	===========================================================================
			
					public:

//	===========================================================================

						/**
						 * Construction
						 * @param root The root control
						 * @param uniqueId The unique id of this control
						 * @param area The area of the control
						 * @param text The label to display
						 */
						CPresetTextLabel(IControlRoot *root, const long uniqueId, const CRect &area, const CString &text);

						/**
						 * Destruction
						 */
						virtual ~CPresetTextLabel();

//	===========================================================================

						/**
						 * Draw the controls
						 * @param graphics The graphics context
						 */
						virtual void drawControl(CGraphics &graphics);

						/**
						 * Handle left button being clicked
						 * @param event The event to handle
						 */
						virtual void handleLeftButtonDown(CMouseEvent &event);

						/**
						 * Handle a double click
						 * @param event The event to handle
						 */
						virtual void handleDoubleClick(CMouseEvent &event);

//	===========================================================================

						/**
						 * Select this control
						 * @param selected If true control is drawn selected, if false is drawn unselected
						 */
						void selectLabel(const bool selected = true);

						/**
						 * Get the selection state
						 * @retval long 0 = not selected
						 */
						long getSelectionState() const;

						/**
						 * Get the string
						 * @retval const CString& The text being displayed
						 */
						const CString &getText() const { return m_text; }

//	===========================================================================

					protected:

//	===========================================================================

						bool m_selected;										/**< Are we the selected control */
						bool m_load;											/**< Should we load */
					};

//	===========================================================================

					long m_pageIndex;											/**< 0 - limit of array */
					TCountedPointerArray<CFileInformation> m_bankFileList;		/**< The list of the files */
					IPresetHandler *m_presetHandler;							/**< The handler for preset information */

					CSystemString m_selectedPath;								/**< Path to selected preset */
					CSystemString m_filePath;									/**< The last path selected */
					CFont *m_theFont;											/**< The font to use */
					CAlphaColour m_fontColour;									/**< The colour to use */
				};

//	===========================================================================

				/**
				 * @class CPresetBrowserHead CPresetBrowser.hpp
				 * @brief The head part of the preset browser with global controls for the unit
				 */
				class CPresetBrowserHead : public CControlPanel, public IActionListener
				{
					/** @cond */
					EXPONENT_CLASS_DECLARATION;
					/** @endcond */

//	===========================================================================
			
				public:

//	===========================================================================

					/**
					 * @struct SPresetBrowserHeadSetup
					 * @brief Setup information for the head of the browser
					 */
					struct SPresetBrowserHeadSetup
					{
						CRect m_bankComboRect;			/**< Size of combo for the head */
						CRect m_loadButtonRect;			/**< Size of the load button for the head */
						CRect m_saveButtonRect;			/**< Size of the save button for the head */

						CSystemString m_rootPath;		/**< Root path, nothing higher than this can be traversed by the selector */

						IImage *m_bankComboUpImage;		/**< Combo box up image */
						IImage *m_bankComboDownImage;	/**< Combo box down image */
						IImage *m_saveButtonUpImage;	/**< Save button up image */
						IImage *m_saveButtonDownImage;	/**< Save button down image */
						IImage *m_loadButtonUpImage;	/**< Load button up image */
						IImage *m_loadButtonDownImage;	/**< Load button down image */

						CFont *m_theFont;				/**< Font for the selector */
						CAlphaColour m_textColour;		/**< Colour of the text for the selector */	
					};

//	===========================================================================

					/**
					 * Construction
					 * @param root The root control
					 * @param uniqueId THe uniqueID of this control
					 * @param area The area of this control
					 * @param listener The action listener
					 * @param presetHandler The preset handler to use
					 * @param selector The selector to interface with
					 */
					CPresetBrowserHead(IControlRoot *root, const long uniqueId, const CRect &area, IActionListener *listener = NULL, IPresetHandler *presetHandler = NULL, CPresetBrowserSelector *selector = NULL);

					/**
					 * Destruction
					 */
					virtual ~CPresetBrowserHead();

//	===========================================================================

					/**
					 * Get the last selected path
					 * @retval const CSystemString& The last selected path 
					 */
					const CSystemString &getBankPath() const { return m_bankPath; }

//	===========================================================================

					/**
					 * Initialise
					 * @param setup The setup information for the browser
					 */
					void intialise(const SPresetBrowserHeadSetup &setup);

					/**
					 * Set menu window attributes
					 * @param windowAttributes The attributes for the menu window
					 * @param colours The colours of the menu window
					 */
					void setMenuWindowAttributes(CWindowAttributes *windowAttributes, const SMenuColours &colours);

					/**
					 * Handle an action event
					 * @param event The event to handle
					 * @note Intended for internal use, do not call
					 */
					virtual void handleActionEvent(const CActionEvent &event);

//	===========================================================================

				protected:

//	===========================================================================

					/**
					 * Create the bank menu
					 */
					void createBankMenu();

//	===========================================================================

					/**
					 * @enum EControlIds
					 * @brief The identifiers for the internal controls
					 */
					enum EControlIds
					{
						e_bankCombo = 0,					/**< Bank selection switch id */
						e_loadButton,						/**< Load button id */
						e_saveButton,						/**< Save button id */
					};

//	===========================================================================

					CSystemString m_bankPath;				/**< The path to the selected bank */
					CComboBox *m_bankCombo;					/**< The bank combo box */
					CMenu *m_bankMenu;						/**< The bank menu */
					CMomentaryButton *m_loadButton;			/**< The load button */
					CMomentaryButton *m_saveButton;			/**< The save button */
					CSystemString m_rootPath;				/**< The root path */
					IPresetHandler *m_presetHandler;		/**< The handler for preset information */
					CPresetBrowserSelector *m_selector;		/**< The selector */
				};

//	===========================================================================

				CPresetBrowserSelector *m_selector;			/**< The selector allows the user to select a preset */
				CPresetBrowserHead *m_presetHead;			/**< The head allows the user to choose a bank etc */
				CSystemString m_rootPath;					/**< The root path that the user cannot go above */
				IPresetHandler *m_presetHandler;			/**< Tha handler for preset information */

			};
		}
    }
}
#endif    // End of CPresetBrowser.hpp
